/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.systems.modules.modules.visuals;

import Krasnodar.rockstarnew.framework.msdf.Fonts;
import Krasnodar.rockstarnew.systems.event.EventListener;
import Krasnodar.rockstarnew.systems.event.impl.game.SoundEvent;
import Krasnodar.rockstarnew.systems.event.impl.render.PreHudRenderEvent;
import Krasnodar.rockstarnew.systems.modules.api.ModuleCategory;
import Krasnodar.rockstarnew.systems.modules.api.ModuleInfo;
import Krasnodar.rockstarnew.systems.modules.impl.BaseModule;
import Krasnodar.rockstarnew.systems.setting.settings.SelectSetting;
import Krasnodar.rockstarnew.utility.colors.ColorRGBA;
import Krasnodar.rockstarnew.utility.render.Utils;
import Krasnodar.rockstarnew.utility.render.batching.Batching;
import Krasnodar.rockstarnew.utility.render.batching.impl.FontBatching;
import Krasnodar.rockstarnew.utility.render.batching.impl.RectBatching;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1113;
import net.minecraft.class_1802;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

@ModuleInfo(name="Sound ESP", category=ModuleCategory.VISUALS, enabledByDefault=true, desc="\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0435\u0442 \u0433\u0434\u0435 \u0431\u044b\u043b \u0432\u043e\u0441\u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d \u0437\u0432\u0443\u043a")
public class SoundESP
extends BaseModule {
    private final SelectSetting select = new SelectSetting(this, "\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0442\u044c");
    private final SelectSetting.Value trident = new SelectSetting.Value(this.select, "\u0422\u0440\u0435\u0437\u0443\u0431\u0435\u0446").select();
    private final SelectSetting.Value tnt = new SelectSetting.Value(this.select, "\u0414\u0438\u043d\u0430\u043c\u0438\u0442");
    private final SelectSetting.Value fireworks = new SelectSetting.Value(this.select, "\u0424\u0435\u0439\u0435\u0440\u0432\u0435\u0440\u043a\u0438");
    private final Map<String, SoundMarker> markers = new HashMap<String, SoundMarker>();
    private final Set<String> TARGET_SOUNDS = new HashSet<String>(Arrays.asList("minecraft:entity.generic.explode", "minecraft:item.trident.throw", "minecraft:item.trident.return", "minecraft:entity.firework_rocket.launch"));
    private final EventListener<SoundEvent> onSoundInstanceEvent = event -> {
        class_1113 sound = event.getSound();
        class_2960 soundId = sound.method_4775();
        String soundIdStr = soundId.toString();
        if (this.TARGET_SOUNDS.contains(soundIdStr)) {
            boolean add = false;
            if (soundIdStr.contains("generic.explode") && this.tnt.isSelected()) {
                add = true;
            } else if ((soundIdStr.contains("trident.throw") || soundIdStr.contains("trident.return")) && this.trident.isSelected()) {
                add = true;
            } else if (soundIdStr.contains("firework_rocket.launch") && this.fireworks.isSelected()) {
                add = true;
            }
            if (add && SoundESP.mc.field_1724 != null && SoundESP.mc.field_1687 != null) {
                String displayName = this.simplifySoundName(soundIdStr);
                long creationTime = System.currentTimeMillis();
                String key = displayName + "_" + creationTime;
                class_243 pos = new class_243(sound.method_4784(), sound.method_4779(), sound.method_4778());
                this.add(key, displayName, pos.field_1352, pos.field_1351, pos.field_1350);
            }
        }
    };
    private final EventListener<PreHudRenderEvent> onHudRenderEvent = event -> {
        class_4587 matrices = event.getContext().method_51448();
        long currentTime = System.currentTimeMillis();
        this.markers.entrySet().removeIf(entry -> {
            SoundMarker markerx = (SoundMarker)entry.getValue();
            return currentTime - markerx.creationTime > 5000L;
        });
        RectBatching rect = new RectBatching(class_290.field_1576, event.getContext().method_51448());
        for (SoundMarker marker : this.markers.values()) {
            float distance = (float)SoundESP.mc.field_1724.method_19538().method_1022(marker.pos);
            String text = marker.name + " (" + String.format("%.1f", Float.valueOf(distance)) + "m)";
            this.renderBack((PreHudRenderEvent)event, matrices, text, marker);
        }
        ((Batching)rect).draw();
        FontBatching batching = new FontBatching(class_290.field_1575, Fonts.MEDIUM);
        for (SoundMarker marker : this.markers.values()) {
            float distance = (float)SoundESP.mc.field_1724.method_19538().method_1022(marker.pos);
            String text = marker.name + " (" + String.format("%.1f", Float.valueOf(distance)) + "m)";
            this.renderText((PreHudRenderEvent)event, matrices, text, marker);
        }
        batching.draw();
    };

    private void renderText(PreHudRenderEvent event, class_4587 matrices, String displayText, SoundMarker marker) {
        class_243 renderPos = marker.pos;
        class_243 renderPosAdjusted = renderPos.method_1031(0.0, 0.5, 0.0);
        class_241 screenPos = Utils.worldToScreen(renderPosAdjusted);
        if (screenPos != null) {
            float distance = (float)SoundESP.mc.field_1724.method_19538().method_1022(renderPos);
            float scale = class_3532.method_15363((float)(1.0f - distance / 20.0f), (float)0.5f, (float)1.0f);
            String text = marker.name + " (" + String.format("%.1f", Float.valueOf(distance)) + "m)";
            int width = (int)Fonts.MEDIUM.getFont(11.0f).width(text);
            int x = -width / 2;
            matrices.method_22903();
            matrices.method_46416(screenPos.field_1343, screenPos.field_1342, 0.0f);
            matrices.method_22905(scale, scale, 1.0f);
            event.getContext().drawText(Fonts.MEDIUM.getFont(11.0f), text, x + 16, 5.0f, ColorRGBA.WHITE);
            if (marker.name.toLowerCase().contains("\u0432\u0437\u0440\u044b\u0432")) {
                event.getContext().drawItem(class_1802.field_8626, (float)x, 3.0f, 0.75f);
            } else if (marker.name.toLowerCase().contains("\u0442\u0440\u0435\u0437\u0443\u0431\u0435\u0446")) {
                event.getContext().drawItem(class_1802.field_8547, (float)x, 3.0f, 0.75f);
            } else if (marker.name.toLowerCase().contains("\u0444\u0435\u0439\u0435\u0440\u0432\u0435\u0440\u043a")) {
                event.getContext().drawItem(class_1802.field_8639, (float)x, 3.0f, 0.75f);
            }
            matrices.method_22909();
        }
    }

    private void renderBack(PreHudRenderEvent event, class_4587 matrices, String displayText, SoundMarker marker) {
        class_243 renderPos = marker.pos;
        class_243 renderPosAdjusted = renderPos.method_1031(0.0, 0.5, 0.0);
        class_241 screenPos = Utils.worldToScreen(renderPosAdjusted);
        if (screenPos != null) {
            float distance = (float)SoundESP.mc.field_1724.method_19538().method_1022(renderPos);
            float scale = class_3532.method_15363((float)(1.0f - distance / 20.0f), (float)0.5f, (float)1.0f);
            matrices.method_22903();
            matrices.method_46416(screenPos.field_1343, screenPos.field_1342, 0.0f);
            matrices.method_22905(scale, scale, 1.0f);
            int textWidth = (int)Fonts.MEDIUM.getFont(11.0f).width(displayText);
            int x = -textWidth / 2;
            boolean y = true;
            event.getContext().drawRect(x - 3, (float)y, textWidth + 26, Fonts.MEDIUM.getFont(11.0f).height() + 8.0f, new ColorRGBA(0.0f, 0.0f, 0.0f, 100.0f));
            matrices.method_22909();
        }
    }

    private void add(String key, String displayName, double x, double y, double z) {
        class_243 pos = new class_243(x, y, z);
        this.markers.put(key, new SoundMarker(displayName, pos, System.currentTimeMillis()));
    }

    private String simplifySoundName(String soundId) {
        if (soundId.contains("generic.explode")) {
            return "\u0412\u0437\u0440\u044b\u0432";
        }
        if (soundId.contains("trident.throw")) {
            return "\u0422\u0440\u0435\u0437\u0443\u0431\u0435\u0446 \u0431\u0440\u043e\u0448\u0435\u043d";
        }
        if (soundId.contains("trident.return")) {
            return "\u0422\u0440\u0435\u0437\u0443\u0431\u0435\u0446";
        }
        return soundId.contains("firework_rocket.launch") ? "\u0424\u0435\u0439\u0435\u0440\u0432\u0435\u0440\u043a" : soundId.replace("minecraft:", "");
    }

    record SoundMarker(String name, class_243 pos, long creationTime) {
    }
}

